﻿using Microsoft.SharePoint;

namespace AddUserToGroup
{
   class Program
   {
      static void Main(string[] args)
      {
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            using (SPWeb web = site.OpenWeb())
            {
               // Neue SharePoint-Gruppe erstellen
               web.SiteGroups.Add(
                  "Meine Gruppe",      // Name
                  web.CurrentUser,     // Standard-Benutzer
                  web.CurrentUser,     // Besitzer der Gruppen
                  "Generiert per Code");

               // SPGroup-Objekt der Gruppe beschaffen
               SPGroup newGroup = web.SiteGroups["Meine Gruppe"];

               // Erzeugung eines neuen SPUser-Objekts
               string userLogin = @"CONTOSO\MargaS";

               // Benutzer registrieren
               web.EnsureUser(userLogin);

               // Benutzer referenzieren
               SPUser userB = web.AllUsers[userLogin];

               // Benutzer der Gruppe hinzufügen
               newGroup.AddUser(userB);

               // Gruppe berechtigen

               // Neue Rollenzuweisung erzeugen
               SPRoleAssignment roleAssign =
                  new SPRoleAssignment(newGroup);

               // Role Definition für Teilnehmen erzeugen
               SPRoleDefinition roleDefContribute =
                  web.RoleDefinitions["Teilnehmen"];

               // Der Rolle das Recht Teilnehmen hinzufügen
               roleAssign.RoleDefinitionBindings.Add(roleDefContribute);

               // Die Rolle dem Web hinzufügen
               web.RoleAssignments.Add(roleAssign);
            }
         }
      }
   }
}